<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$unique_id 		= pressmart_uniqid('section-');
$slider_data 	= shortcode_atts( pressmart_slider_options() ,array(
	'slider_autoplay'   => ( pressmart_get_option( 'related-upsell-auto-play', 1) ) ? true : false,
	'slider_loop'   	=> ( pressmart_get_option( 'related-upsell-loop', 1) ) ? true : false,
	'slider_autoHeight'	=>  false,
	'slider_nav'     	=> ( pressmart_get_option( 'related-upsell-navigation', 1) ) ? true : false,
	'slider_dots'     	=> ( pressmart_get_option( 'related-upsell-product-dots', 1) ) ? true : false,
	'rs_extra_large'	=> pressmart_get_option( 'related-upsell-products-columns', 5 ),			
	'rs_large'			=> pressmart_get_option( 'related-upsell-products-columns', 5 ),			
	'rs_medium'			=> pressmart_get_option( 'related-upsell-products-columns-tablet', 3 ),		
	'rs_small'			=> pressmart_get_option( 'related-upsell-products-columns-mobile', 2 ),	
	'rs_extra_small'    => pressmart_get_option( 'related-upsell-products-columns-mobile', 2 ),
));
pressmart_set_loop_prop( 'name', 'pressmart-carousel' );
pressmart_set_loop_prop( 'products-columns', pressmart_get_option( 'related-upsell-products-columns', 5 ) );
pressmart_set_loop_prop('rs_large', pressmart_get_option( 'related-upsell-products-columns', 5 ) );
pressmart_set_loop_prop('rs_medium', pressmart_get_option( 'related-upsell-products-columns-tablet', 3 ) );
pressmart_set_loop_prop('rs_extra_small', pressmart_get_option( 'related-upsell-products-columns-mobile', 2 ) );
pressmart_set_loop_prop( 'unique_id', $unique_id );
pressmart_set_loop_prop( 'owl_options', wp_json_encode( $slider_data ) );

if ( $recently_viewed_products ) : ?>

	<section class="recently-viewed">

		<h2><?php esc_html_e( 'Recently Viewed', 'pressmart' ); ?></h2>

		<?php woocommerce_product_loop_start(); ?>

			<?php foreach ( $recently_viewed_products as $product_id ) : ?>
				<?php
				 	$post_object = get_post( $product_id );
					if($post_object){
						setup_postdata( $GLOBALS['post'] =& $post_object );
						wc_get_template_part( 'content', 'product' );
					}
				?>
			<?php endforeach; ?>

		<?php woocommerce_product_loop_end(); ?>

	</section>

<?php endif;

wp_reset_postdata();
