<?php
/**
 * Template part for displaying portfolio layout
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package pressmart/template-parts/portfolio
 * @since 1.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if( pressmart_get_loop_prop( 'name' ) == 'related-portfolios' ) {
	$classes[] = 'portfolio-post-loop';
	$classes[] = 'related-portfolio';
}elseif( pressmart_get_loop_prop( 'name' ) == 'portfolio-slider-widget' ) {
	$classes[] = 'portfolio-post-loop';
	$classes[] = 'portfolio-slider-widget';
}else{
	$classes[] = 'portfolio-post-loop';
	$classes[] = 'col-lg-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'portfolio-grid-columns' ) );
	$classes[] = 'col-md-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'portfolio-grid-columns-tablet' ) );
	$classes[] = 'col-' .pressmart_get_rs_grid_columns( pressmart_get_loop_prop( 'blog-grid-columns-mobile' ) );
}
?>

<?php do_action( 'pressmart_before_portfolio_loop_entry' ); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $classes ) ?> > 
	
	<?php
	/**
	 * pressmart_portfolio_loop_entry_top hook.
	 *
	 * @hooked pressmart_post_wrapper - 10
	 */
	do_action( 'pressmart_portfolio_loop_entry_top' );
	?>
	
	<div class="entry-thumbnail-wrapper">
		<?php 
		/**
		 * pressmart_portfolio_loop_thumbnail hook.
		 *
		 * @hooked pressmart_template_portfolio_loop_thumbnail - 10
		 * @hooked pressmart_template_portfolio_loop_action_icon - 20
		 */
		do_action( 'pressmart_portfolio_loop_thumbnail' );
		?>
	</div>
	
	<div class="entry-content-wrapper">
		<?php	
		/**
		 * pressmart_portfolio_loop_content hook.
		 *
		 * @hooked pressmart_portfolio_loop_header 	- 10
		 * @hooked pressmart_portfolio_loop_content - 20
		 * @hooked pressmart_portfolio_loop_footer 	- 30
		 */
		do_action( 'pressmart_portfolio_loop_content' );
		?>
	</div>
	
	<?php	
	/**
	 * pressmart_portfolio_loop_entry_bottom hook.
	 *
	 * @hooked pressmart_post_wrapper_end - 10
	 */
	do_action( 'pressmart_portfolio_loop_entry_bottom' );
	?>
		
</article>

<?php
do_action( 'pressmart_after_portfolio_loop_entry' );