<?php
/**
 * Template part for displaying footer
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package pressmart/template-parts/footer
 * @since 1.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<footer id="footer" class="site-footer">	
	
	<?php do_action( 'pressmart_footer_top' ); ?>
	
	<?php if( $site_footer ) { ?>
		<div class="footer-main footer-layout-<?php echo esc_attr( pressmart_get_option( 'footer-layout', '2' ) );?>">
			<div class="container">
				<?php if( ! empty( $footer_layout_data ) ){ ?>
					<div class="row">
						<?php
						$collapse_class = pressmart_get_option( 'footer-widget-collapse', 0 ) ? ' footer-widget-collapse' : '';
						foreach($footer_layout_data['class'] as $key => $classes){
							$count = $key + 1;
							?>
							<div class="footer-widget<?php echo esc_attr( $collapse_class ); ?> <?php echo esc_attr( $classes ); ?>">
								<?php dynamic_sidebar( 'footer-widget-area-' . $count ); ?>
							</div>
							<?php
						} ?>
					</div>
				<?php } ?>
			</div><!-- .container -->	
		</div><!-- .footer-main -->
	<?php }?>
	
	<?php
	/**
	 * Hook: pressmart_footer_bottom.
	 *
	 * @hooked pressmart_template_footer_copyright- 10
	 */
	do_action( 'pressmart_footer_bottom' );
	?>		
	
</footer><!-- .site-footer -->