<?php
/**
 * Template for displaying search forms
 *
 * @author 	PressLayouts
 * @package pressmart
 * @since 1.0
 */

?>

<?php $unique_id = esc_attr( pressmart_uniqid('search-form-') ); ?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<input type="search" id="<?php echo esc_attr($unique_id); ?>" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'pressmart' ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" />
	<button type="submit" class="search-submit"><?php esc_html_e('Search','pressmart');?></button>
</form>
