<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package pressmart
 * @since 1.0
 */

get_header(); ?>

<?php if( ! pressmart_has_elementor_template( 'archive' ) ) :
	/**
	 * Hook: pressmart_before_main_content.
	 *
	 * @hooked pressmart_output_content_wrapper - 10 (outputs opening divs for the content area)
	 */
	do_action( 'pressmart_before_main_content' );

	if ( have_posts() ) :

		do_action( 'pressmart_before_loop_post' );
		
		pressmart_post_loop_start();
		
		while ( have_posts() ) :
			the_post();	
			
			// Include the loop post content template.
			get_template_part( 'template-parts/post-loop/layout', get_post_format() );

		endwhile;
		
		pressmart_post_loop_end();
		
		/**
		 * Hook: pressmart_after_loop_post.
		 *
		 * @hooked pressmart_pagination - 10
		 */
		do_action( 'pressmart_after_loop_post' );

	else :

		get_template_part( 'template-parts/post-loop/content', 'none' );

	endif;

	/**
	 * Hook: pressmart_after_main_content.
	 *
	 * @hooked pressmart_output_content_wrapper_end - 10 (outputs closing divs for the content)
	 */
	do_action( 'pressmart_after_main_content' );

	/**
	 * Hook: pressmart_sidebar.
	 *
	 * @hooked pressmart_get_sidebar - 10
	 */
	do_action( 'pressmart_sidebar' );
endif; ?>

<?php get_footer();
