<?php
/**
 * Action/filter hooks used for theme functions/templates.
 *
 * @author 		PressLayouts
 * @package 	pressmart/inc
 * @since     	1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_filter( 'body_class', 'pressmart_body_classes' );
add_filter( 'post_class', 'pressmart_post_classes', 10, 3 );

add_action( 'pressmart_body_top', 'pressmart_site_loader', 1 );

/**
 * Content Wrappers.
 *
 * @see pressmart_output_content_wrapper()
 * @see pressmart_output_content_wrapper_end()
 */
add_action( 'pressmart_before_main_content', 'pressmart_output_content_wrapper', 10 );
add_action( 'pressmart_after_main_content', 'pressmart_output_content_wrapper_end', 10 );

/**
 * Header.
 *
 * @see pressmart_template_header()
 * @see pressmart_header_topbar_left()
 * @see pressmart_header_topbar_right()
 * @see pressmart_header_main_left()
 * @see pressmart_header_main_center()
 * @see pressmart_header_main_right()
 * @see pressmart_header_navigation_left()
 * @see pressmart_header_navigation_center()
 * @see pressmart_header_navigation_right()
 */
add_action( 'pressmart_header', 'pressmart_template_header', 10 );
add_action( 'pressmart_header_topbar_left', 'pressmart_header_topbar_left', 10 );
add_action( 'pressmart_header_topbar_right', 'pressmart_header_topbar_right', 10 );
add_action( 'pressmart_header_main_left', 'pressmart_header_main_left', 10 );
add_action( 'pressmart_header_main_center', 'pressmart_header_main_center', 10 );
add_action( 'pressmart_header_main_right', 'pressmart_header_main_right', 10 );
add_action( 'pressmart_header_navigation_left', 'pressmart_header_navigation_left', 10 );
add_action( 'pressmart_header_navigation_center', 'pressmart_header_navigation_center', 10 );
add_action( 'pressmart_header_navigation_right', 'pressmart_header_navigation_right', 10 );
add_action( 'pressmart_header_sticky_left', 'pressmart_header_sticky_left', 10 );
add_action( 'pressmart_header_sticky_center', 'pressmart_header_sticky_center', 10 );
add_action( 'pressmart_header_sticky_right', 'pressmart_header_sticky_right', 10 );
add_action( 'pressmart_header_mobile_topbar_center', 'pressmart_header_mobile_topbar_center', 10 );
add_action( 'pressmart_header_mobile_left', 'pressmart_header_mobile_left', 10 );
add_action( 'pressmart_header_mobile_center', 'pressmart_header_mobile_center', 10 );
add_action( 'pressmart_header_mobile_right', 'pressmart_header_mobile_right', 10 );

/**
 * Page Title.
 *
 * @see pressmart_template_page_title()
 * @see pressmart_template_breadcrumbs()
 */
add_action( 'pressmart_page_title', 'pressmart_page_title', 10 );
add_action( 'pressmart_inner_page_title', 'pressmart_template_page_title', 10 );
add_action( 'pressmart_inner_page_title', 'pressmart_template_breadcrumbs', 20 );

/**
 * Page
 *
 * @see pressmart_template_page_content()
 * @see pressmart_template_page_comments()
 */
add_action( 'pressmart_page_content', 'pressmart_template_page_content', 10 );
add_action( 'pressmart_after_page_entry', 'pressmart_template_page_comments', 10 );

/**
 * Sidebar.
 *
 * @see pressmart_get_sidebar()
 */
add_action( 'pressmart_sidebar', 'pressmart_get_sidebar', 10 );

/**
 * Post Loop.
 *
 * @see pressmart_post_wrapper()
 * @see pressmart_template_loop_post_date()
 * @see pressmart_template_loop_post_highlight()
 * @see pressmart_template_loop_post_thumbnail()
 * @see pressmart_template_loop_post_header()
 * @see pressmart_template_loop_post_title()
 * @see pressmart_template_loop_post_meta()
 * @see pressmart_template_loop_post_content()
 * @see pressmart_template_loop_post_footer()
 * @see pressmart_template_read_more_link()
 * @see pressmart_post_wrapper_end()
 * @see pressmart_pagination()
 */
 
add_action( 'pressmart_loop_post_entry_top', 'pressmart_post_wrapper', 10 );
add_action( 'pressmart_loop_post_thumbnail', 'pressmart_template_loop_post_date', 10 );
add_action( 'pressmart_loop_post_thumbnail', 'pressmart_template_loop_post_highlight', 10 );
add_action( 'pressmart_loop_post_thumbnail', 'pressmart_template_loop_post_thumbnail', 20 );
add_action( 'pressmart_loop_post_content', 'pressmart_template_loop_post_header', 10 );
add_action( 'pressmart_loop_post_content', 'pressmart_template_loop_post_content', 20 );
add_action( 'pressmart_loop_post_content', 'pressmart_template_loop_post_footer', 30 );
add_action( 'pressmart_loop_post_entry_bottom', 'pressmart_post_wrapper_end', 10 );
add_action( 'pressmart_after_loop_post', 'pressmart_pagination', 10 );

//Inner hook
add_action( 'pressmart_loop_post_header', 'pressmart_template_loop_post_category', 5 );
add_action( 'pressmart_loop_post_header', 'pressmart_template_loop_post_title', 10 );
add_action( 'pressmart_loop_post_header', 'pressmart_template_loop_post_meta', 20 );
add_action( 'pressmart_loop_post_footer', 'pressmart_template_read_more_link', 10 );

/**
 * Single Post.
 *
 * @see pressmart_post_wrapper()
 * @see pressmart_template_single_post_date()
 * @see pressmart_template_single_post_thumbnail()
 * @see pressmart_template_single_post_highlight()
 * @see pressmart_template_single_post_header()
 * @see pressmart_template_single_post_content()
 * @see pressmart_post_wrapper_end()
 * @see pressmart_template_single_post_author_bios()
 * @see pressmart_template_single_tag_social_share()
 * @see pressmart_template_single_post_navigation()
 * @see pressmart_template_single_post_related()
 * @see pressmart_template_single_post_comments()
 * @see pressmart_template_single_post_category()
 * @see pressmart_template_single_post_title()
 * @see pressmart_template_single_post_meta()
 */
 
add_action( 'pressmart_single_post_entry_top', 'pressmart_post_wrapper', 10 );
add_action( 'pressmart_single_post_entry_top', 'pressmart_template_single_post_header', 15 );
add_action( 'pressmart_single_post_thumbnail', 'pressmart_template_single_post_date', 10 );
add_action( 'pressmart_single_post_thumbnail', 'pressmart_template_single_post_thumbnail', 10 );
add_action( 'pressmart_single_post_thumbnail', 'pressmart_template_single_post_highlight', 20 );
add_action( 'pressmart_single_post_content', 'pressmart_template_single_post_content', 10 );
add_action( 'pressmart_single_post_entry_bottom', 'pressmart_post_wrapper_end', 10 );
add_action( 'pressmart_after_single_post_entry', 'pressmart_template_single_post_author_bios', 10 );
add_action( 'pressmart_after_single_post_entry', 'pressmart_template_single_tag_social_share', 20 );
add_action( 'pressmart_after_single_post_entry', 'pressmart_template_single_post_navigation', 30 );
add_action( 'pressmart_after_single_post_entry', 'pressmart_template_single_post_related', 40 );
add_action( 'pressmart_after_single_post_entry', 'pressmart_template_single_post_comments', 50 );

//Inner hook
add_action( 'pressmart_single_post_header', 'pressmart_template_single_post_category', 5 );
add_action( 'pressmart_single_post_header', 'pressmart_template_single_post_title', 10 );
add_action( 'pressmart_single_post_header', 'pressmart_template_single_post_meta', 20 );

/**
 * Portfolio Loop.
 *
 * @see pressmart_template_portfolio_filter()
 * @see pressmart_post_wrapper()
 * @see pressmart_template_portfolio_loop_thumbnail()
 * @see pressmart_template_portfolio_loop_action_icon()
 * @see pressmart_template_portfolio_loop_header()
 * @see pressmart_post_wrapper_end()
 * @see pressmart_template_portfolio_loop_categories()
 * @see pressmart_template_portfolio_loop_title()
 * @see pressmart_portfolio_pagination()
 */
add_action( 'pressmart_before_portfolio_loop', 'pressmart_template_portfolio_filter', 10 );
add_action( 'pressmart_portfolio_loop_entry_top', 'pressmart_post_wrapper', 10 );
add_action( 'pressmart_portfolio_loop_thumbnail', 'pressmart_template_portfolio_loop_thumbnail', 10 );
add_action( 'pressmart_portfolio_loop_thumbnail', 'pressmart_template_portfolio_loop_action_icon', 20 );
add_action( 'pressmart_portfolio_loop_content', 'pressmart_template_portfolio_loop_header', 10 );
add_action( 'pressmart_portfolio_loop_entry_bottom', 'pressmart_post_wrapper_end', 10 );
add_action( 'pressmart_after_portfolio_loop', 'pressmart_portfolio_pagination', 10 );

//Inner hook 
add_action( 'pressmart_portfolio_loop_header', 'pressmart_template_portfolio_loop_categories',10 );
add_action( 'pressmart_portfolio_loop_header', 'pressmart_template_portfolio_loop_title',20 );;

/**
 * Single Post.
 *
 * @see pressmart_post_wrapper()
 * @see pressmart_template_single_portfolio_image()
 * @see pressmart_template_single_portfolio_title()
 * @see pressmart_template_single_portfolio_content()
 * @see pressmart_template_single_portfolio_client()
 * @see pressmart_template_single_portfolio_date()
 * @see pressmart_template_single_portfolio_category()
 * @see pressmart_template_single_portfolio_skill()
 * @see pressmart_template_single_portfolio_share()
 * @see pressmart_template_single_portfolio_navigation()
 * @see pressmart_template_single_related_portfolio()
 * @see pressmart_template_single_portfolio_comments()
 * @see pressmart_post_wrapper_end()
 */
add_action( 'pressmart_single_portfolio_entry_top', 'pressmart_post_wrapper', 10 );
add_action( 'pressmart_single_portfolio_image', 'pressmart_template_single_portfolio_image', 10 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_title', 5 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_content', 10 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_preview', 15 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_client', 20 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_date', 25 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_category', 30 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_skill', 35 );
add_action( 'pressmart_single_portfolio_summary', 'pressmart_template_single_portfolio_share', 40 );
add_action( 'pressmart_after_single_portfolio_entry', 'pressmart_template_single_portfolio_navigation', 10 );
add_action( 'pressmart_after_single_portfolio_entry', 'pressmart_template_single_related_portfolio', 20 );
add_action( 'pressmart_after_single_portfolio_entry', 'pressmart_template_single_portfolio_comments', 30 );
add_action( 'pressmart_single_portfolio_entry_bottom', 'pressmart_post_wrapper_end', 10 );

/* Comming Soon */
add_action( 'template_redirect', 'pressmart_coming_soon_redirect' );

/**
 * Footer.
 *
 * @see pressmart_template_footer()
 * @see pressmart_template_footer_copyright()
 * @see pressmart_back_to_top()
 * @see pressmart_mobile_menu()
 * @see pressmart_search_popup()
 * @see pressmart_newsletter_popup()
 * @see pressmart_mobile_bottom_navbar()
 * @see pressmart_mask_overaly()
 */
add_action( 'pressmart_footer_top', 'pressmart_template_footer_subscribe', 10 );
add_action( 'pressmart_footer', 'pressmart_template_footer', 10 );
add_action( 'pressmart_footer_bottom', 'pressmart_template_footer_categories', 5 );
add_action( 'pressmart_footer_bottom', 'pressmart_template_footer_copyright', 10 );
add_action( 'pressmart_body_bottom', 'pressmart_back_to_top', 10 );
add_action( 'pressmart_body_bottom', 'pressmart_mobile_menu', 20 );
add_action( 'pressmart_body_bottom', 'pressmart_search_popup', 25 );
add_action( 'pressmart_body_bottom', 'pressmart_newsletter_popup', 30 );
add_action( 'pressmart_body_bottom', 'pressmart_mobile_bottom_navbar', 40 );
add_action( 'pressmart_body_bottom', 'pressmart_mask_overaly', 100 );