<?php 
/**
 * Action/filter hooks used for woocommerce functions/templates.
 *
 * @author 		PressLayouts
 * @package 	pressmart/inc
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_theme_support( 'woocommerce');
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
add_filter('woocommerce_show_page_title', '__return_false');
add_filter( 'body_class', 'pressmart_body_woocommerce_classes' );

/**
 * PressMart Header
 *
 * @see pressmart_ajax_wishlist_count()
 * @see pressmart_ajax_compare_count()
 * @see pressmart_empty_mini_cart_button()
 */
add_action( 'wp_ajax_pressmart_ajax_wishlist_count', 'pressmart_ajax_wishlist_count' );
add_action( 'wp_ajax_nopriv_pressmart_ajax_wishlist_count', 'pressmart_ajax_wishlist_count' );
add_action( 'wp_ajax_pressmart_ajax_compare_count', 'pressmart_ajax_compare_count' );
add_action( 'wp_ajax_nopriv_pressmart_ajax_compare_count', 'pressmart_ajax_compare_count' );
add_action( 'pressmart_after_empty_mini_cart', 'pressmart_empty_mini_cart_button', 20 );

/**
 * Content Wrappers
 *
 * @see pressmart_output_content_wrapper()
 * @see pressmart_output_content_wrapper_end()
 * @see pressmart_reset_loop()
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

add_action( 'woocommerce_before_main_content', 'pressmart_output_content_wrapper', 10 );
add_action( 'woocommerce_after_main_content', 'pressmart_output_content_wrapper_end', 10 );

add_action( 'woocommerce_after_shop_loop', 'pressmart_reset_loop', 999 );

/**
 * Products Loop
 *
 * @see pressmart_before_shop_loop()
 * @see pressmart_shop_page_title()
 * @see pressmart_product_loop_view()
 * @see pressmart_product_loop_show()
 * @see pressmart_active_filter_widgets()
 * @see pressmart_clear_filters_btn()
 * @see pressmart_loop_product_wrapper()
 * @see pressmart_before_shop_loop_item_title()
 * @see pressmart_output_product_labels()
 * @see pressmart_product_loop_quick_view_button()
 * @see pressmart_template_loop_product_thumbnail()
 * @see pressmart_shop_loop_item_title()
 * @see pressmart_loop_product_info_wrapper()
 * @see pressmart_product_title_rating_wrapper()
 * @see pressmart_product_loop_categories()
 * @see pressmart_product_price_buttons_wrapper()
 * @see pressmart_after_shop_loop_item_title()
 * @see pressmart_product_sale_percentage()
 * @see pressmart_product_loop_buttons_variations()
 * @see pressmart_template_loop_action_buttons()
 * @see pressmart_product_loop_cart_button()
 * @see pressmart_product_loop_wishlist_button()
 * @see pressmart_product_loop_compare_button()
 * @see pressmart_stock_progress_bar()
 * @see pressmart_sale_product_countdown()
 * @see pressmart_after_shop_loop_item()
 * @see pressmart_product_wrapper_end()
 */
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

add_action( 'woocommerce_before_shop_loop', 'pressmart_before_shop_loop', 20 );
add_action( 'pressmart_shop_loop_header_left', 'pressmart_product_off_canvas_sidebar', 5 );
add_action( 'pressmart_shop_loop_header_left', 'pressmart_shop_page_title', 10 );
add_action( 'pressmart_shop_loop_header_left', 'woocommerce_result_count', 20 );
add_action( 'pressmart_shop_loop_header_right', 'pressmart_product_loop_view', 20 );
add_action( 'pressmart_shop_loop_header_right', 'pressmart_product_loop_show', 25 );
add_action( 'pressmart_shop_loop_header_right', 'woocommerce_catalog_ordering', 30 );
add_action( 'woocommerce_before_shop_loop', 'pressmart_active_filter_widgets', 30 );
add_action( 'pressmart_before_active_filters_widgets', 'pressmart_clear_filters_btn', 30 );
add_action( 'woocommerce_before_shop_loop_item', 'pressmart_loop_product_wrapper', 5 );
add_action( 'woocommerce_before_shop_loop_item_title', 'pressmart_before_shop_loop_item_title', 10 );
add_action( 'pressmart_before_shop_loop_item_title', 'pressmart_output_product_labels', 5 );
//add_action( 'pressmart_before_shop_loop_item_title', 'pressmart_sale_product_countdown', 8 );
add_action( 'pressmart_before_shop_loop_item_title', 'pressmart_product_loop_quick_view_button', 10 );
add_action( 'pressmart_before_shop_loop_item_title', 'pressmart_template_loop_product_thumbnail', 15 );
add_action( 'woocommerce_shop_loop_item_title', 'pressmart_shop_loop_item_title', 10 );
add_action( 'pressmart_shop_loop_item_title', 'pressmart_loop_product_info_wrapper', 5 );
add_action( 'pressmart_shop_loop_item_title', 'pressmart_product_title_rating_wrapper', 10 );
add_action( 'pressmart_shop_loop_item_title', 'pressmart_product_loop_categories', 15 );
add_action( 'pressmart_shop_loop_item_title', 'woocommerce_template_loop_product_title', 20 );
add_action( 'pressmart_shop_loop_item_title', 'woocommerce_template_loop_rating', 25 );
add_action( 'pressmart_shop_loop_item_title', 'woocommerce_template_single_excerpt', 30 );
add_action( 'pressmart_shop_loop_item_title', 'pressmart_product_wrapper_end', 50 );
add_action( 'woocommerce_after_shop_loop_item_title', 'pressmart_product_price_buttons_wrapper', 5 );
add_action( 'woocommerce_after_shop_loop_item_title', 'pressmart_after_shop_loop_item_title', 10 );
add_action( 'pressmart_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
add_action( 'pressmart_after_shop_loop_item_title', 'pressmart_product_sale_percentage', 20 );
add_action( 'woocommerce_after_shop_loop_item', 'pressmart_product_loop_buttons_variations', 10 );
add_action( 'pressmart_product_loop_buttons_variations', 'pressmart_template_loop_action_buttons', 10 );
//add_action( 'pressmart_template_loop_action_buttons', 'pressmart_product_loop_quantity_field', 5 );
add_action( 'pressmart_template_loop_action_buttons', 'pressmart_product_loop_cart_button', 10 );
add_action( 'pressmart_product_loop_cart_button', 'woocommerce_template_loop_add_to_cart', 10 );
add_action( 'pressmart_template_loop_action_buttons', 'pressmart_product_loop_wishlist_button', 15 );
add_action( 'pressmart_template_loop_action_buttons', 'pressmart_product_loop_compare_button', 20 );
add_action( 'woocommerce_after_shop_loop_item', 'pressmart_stock_progress_bar', 14 );
add_action( 'woocommerce_after_shop_loop_item', 'pressmart_sale_product_countdown', 15 );
add_action( 'woocommerce_after_shop_loop_item', 'pressmart_after_shop_loop_item', 50 );
add_action( 'pressmart_after_shop_loop_item', 'pressmart_product_wrapper_end', 10 );
add_action( 'pressmart_after_shop_loop_item', 'pressmart_product_wrapper_end', 20 );
add_action( 'pressmart_after_shop_loop_item', 'pressmart_product_wrapper_end', 30 );

/**
 * Categories Loop.
 */
add_action( 'woocommerce_before_subcategory', 'pressmart_loop_product_wrapper', 5 );
add_action( 'woocommerce_after_subcategory', 'pressmart_product_wrapper_end', 10 );

/**
 * Single Product
 */
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
 
/**
 * Single Products Summary Div.
 *
 * @see pressmart_output_product_labels()
 * @see pressmart_single_product_video_btn()
 * @see pressmart_single_product_degree360_btn()
 * @see pressmart_single_product_photoswipe_btn()
 * @see pressmart_single_product_before_price()
 * @see pressmart_product_navigation_share()
 * @see pressmart_single_product_navigation()
 * @see woocommerce_template_single_rating()
 * @see pressmart_sale_product_countdown()
 * @see pressmart_single_product_after_price()
 * @see pressmart_single_product_price_discount()
 * @see pressmart_single_product_stock_availability()
 * @see pressmart_single_product_brands()
 * @see pressmart_single_product_size_chart()
 * @see pressmart_single_product_delivery_return_ask_question()
 * @see pressmart_single_product_estimated_delivery()
 * @see pressmart_single_product_visitor_count()
 * @see pressmart_single_product_policy()
 * @see pressmart_single_product_trust_badge()
 * @see pressmart_single_product_share()
 * @see pressmart_output_recently_viewed_products()
 */

add_action( 'pressmart_product_gallery_top', 'pressmart_output_product_labels', 10 ); 
add_action( 'pressmart_product_gallery_bottom', 'pressmart_single_product_video_btn', 10 );
add_action( 'pressmart_product_gallery_bottom', 'pressmart_single_product_degree360_btn', 15 );
add_action( 'pressmart_product_gallery_bottom', 'pressmart_single_product_photoswipe_btn', 20 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_before_price', 6 );
add_action( 'pressmart_single_product_before_price', 'pressmart_product_navigation_share', 10 );
add_action( 'pressmart_product_navigation_share', 'pressmart_single_product_navigation', 10);
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 8);
add_action( 'woocommerce_single_product_summary', 'pressmart_sale_product_countdown', 9);
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_after_price', 12);
add_action( 'pressmart_single_product_after_price', 'pressmart_single_product_price_discount', 5 );
add_action( 'pressmart_single_product_after_price', 'pressmart_single_product_stock_availability', 6 );
add_action( 'pressmart_single_product_after_price', 'pressmart_single_product_brands', 15 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_size_chart', 35 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_delivery_return_ask_question', 36 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_estimated_delivery', 37 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_visitor_count', 38 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_policy', 39 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_trust_badge', 39 );
add_action( 'woocommerce_single_product_summary', 'pressmart_single_product_share', 50 );
add_action( 'woocommerce_after_single_product_summary', 'pressmart_output_recently_viewed_products', 25 );

/* Quick Buy*/
add_action( 'woocommerce_after_add_to_cart_button', 'pressmart_add_quick_buy_pid');
add_action( 'woocommerce_after_add_to_cart_button', 'pressmart_add_quick_buy_button', 99 );
add_filter( 'woocommerce_add_to_cart_redirect', 'pressmart_quick_buy_redirect', 99 );

/**
 * Quantity Buttons
 *
 * @see pressmart_quantity_button_minus()
 * @see pressmart_quantity_button_plus()
 */
add_action( 'woocommerce_before_quantity_input_field', 'pressmart_quantity_button_minus', 10 );
add_action( 'woocommerce_after_quantity_input_field', 'pressmart_quantity_button_plus', 10 );

/**
 * My Account Page
 */
remove_action( 'woocommerce_register_form', 'wc_registration_privacy_policy_text', 20 );

add_action( 'pressmart_before_signup_form', 'wc_registration_privacy_policy_text', 10 );
add_action( 'woocommerce_before_account_navigation', 'pressmart_before_account_navigation' );
add_action( 'woocommerce_after_account_navigation', 'pressmart_after_account_navigation' );
add_action( 'woocommerce_before_account_orders', 'pressmart_woocommerce_before_account_orders', 10 );
add_action( 'woocommerce_before_account_downloads', 'pressmart_woocommerce_before_account_downloads', 10 );
add_filter( 'woocommerce_my_account_my_address_description', 'pressmart_woocommerce_my_account_my_address_description', 10 );
add_action( 'woocommerce_before_edit_account_form', 'pressmart_woocommerce_myaccount_edit_account_heading', 10 );

/**
 * Cart Page
 *
 * @see pressmart_free_shipping_bar()
 * @see pressmart_woocommerce_cart_page_wrapper()
 * @see pressmart_woocommerce_cart_page_wrapper_end()
 * @see woocommerce_cross_sell_display()
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );

add_action( 'woocommerce_proceed_to_checkout', 'pressmart_free_shipping_bar', 10 );
add_action( 'woocommerce_before_cart', 'pressmart_woocommerce_cart_page_wrapper', 10 );
add_action( 'woocommerce_after_cart', 'pressmart_woocommerce_cart_page_wrapper_end', 10 );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display', 20 );

 /**
 * Mini Cart
 *
 * @see pressmart_free_shipping_bar()
 */
add_action( 'woocommerce_widget_shopping_cart_before_buttons', 'pressmart_free_shipping_bar', 10 );

/**
 * Footer
 *
 * @see pressmart_login_signup_popup()
 * @see pressmart_minicart_slide()()
 * @see pressmart_canvas_sidebar()
 * @see pressmart_single_product_360_degree_content()
 * @see pressmart_sticky_add_to_cart_button()
 */
add_action( 'pressmart_body_bottom', 'pressmart_login_signup_popup', 50 );
add_action( 'pressmart_body_bottom', 'pressmart_minicart_slide', 55 );
add_action( 'pressmart_body_bottom', 'pressmart_canvas_sidebar', 60 );
add_action( 'pressmart_body_bottom', 'pressmart_single_product_360_degree_content', 65 );
add_action( 'pressmart_body_bottom', 'pressmart_sticky_add_to_cart_button', 70 );