<?php  
if ( ! defined('PRESSMART_DIR')) exit('No direct script access allowed');
/**
 * PressMart Metabox
 * @author 		PressLayouts
 * @package 	pressmart/inc
 * @version     1.0
 */
 
if ( ! class_exists( 'PressMart_Metabox' ) ) :

	/**
	 * PressMart_Metabox
	 *
	 * @since 1.0
	 */
	class PressMart_Metabox {
		
		/**
		 * Instance
		 *
		 * @access private
		 * @var object Class object.
		 */
		private static $instance;
		
		private $prefix = PRESSMART_PREFIX;
		
		public $post_types;
		
		/**
		 * Initiator
		 *
		 * @return object initialized object of class.
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}
		
		/**
		 * Constructor
		 */
		public function __construct() {
			$this->post_types = array('post','page','portfolio','product');
			add_action('admin_init',array($this,'register_metaboxes'));
			add_action('admin_enqueue_scripts',array($this,'admin_js_var'));
		}
		
		
		public function meta_boxes(){
			$prefix 	= PRESSMART_PREFIX;
			$meta_box 	= array();
			$size_guide = array();
			
			/* Post Format Meta */
			$meta_boxes[] = array(
				'title' 		=> esc_html__('Post Format', 'pressmart'),
				'id' 			=> $prefix .'meta_box_post_format',
				'post_types' 	=> array('post'),
				'tab'   		=> true,
				'fields' 		=> array(
					array(
						'name' 				=> esc_html__('Image', 'pressmart'),
						'label_description' => esc_html__( 'Select images image for post', 'pressmart' ),
						'id' 				=> $prefix . 'post_format_image',
						'type' 				=> 'image_advanced',
						'max_file_uploads' 	=> 1,
					),
					array(
						'name' 				=> esc_html__('Gallery', 'pressmart'),
						'label_description' => esc_html__( 'Select images gallery for post', 'pressmart' ),
						'id' 				=> $prefix . 'post_format_gallery',
						'type' 				=> 'image_advanced',
					),
					array(
						'name' 				=> esc_html__( 'Video URL or Embeded Code', 'pressmart' ),
						'label_description' => esc_html__( 'Enter the URL or embed code of Vimeo.com or YouTube.com streaming services.<br>To get the code, go to the external video page, click "share" button and copy the Embed code.This setting is used for your video post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_video',
						'type' 				=> 'textarea',
					),
					array(
						'name' 				=> esc_html__( 'Audio URL or Embeded Code', 'pressmart' ),
						'label_description' => esc_html__( 'Enter the URL or Embeded code of the audio.This setting is used for your audio post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_audio',
						'type' 				=> 'textarea',
					),
					array(
						'name' 				=> esc_html__( 'Quote', 'pressmart' ),
						'label_description' => esc_html__( 'Enter your quote.This setting is used for your quote post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_quote',
						'type' 				=> 'textarea',
					),
					array(
						'name' 				=> esc_html__( 'Author', 'pressmart' ),
						'label_description' => esc_html__( 'Enter quote author.This setting is used for your quote post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_quote_author',
						'type' 				=> 'text',
					),
					array(
						'name' 				=> esc_html__( 'Author URL', 'pressmart' ),
						'label_description' => esc_html__( 'Enter quote author url.This setting is used for your quote post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_quote_author_url',
						'type' 				=> 'url',
					),
					array(
						'name' 				=> esc_html__( 'Link', 'pressmart' ),
						'label_description' => esc_html__( 'Enter your external url.This setting is used for your link post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_link_url',
						'type' 				=> 'url',
					),					
					array(
						'name' 				=> esc_html__( 'Text', 'pressmart' ),
						'label_description' => esc_html__( 'Enter link text for link.This setting is used for your link post formats.', 'pressmart' ),
						'id'   				=> $prefix . 'post_format_link_text',
						'type' 				=> 'text',
					),
				),
			);

			/* Portfolio Metabox */
			$meta_boxes[]	= array(
				'title'			=> esc_html__('Portfolio Informations', 'pressmart'),
				'id'			=> $prefix .'portfolio_informations',
				'post_types'	=> array('portfolio'),
				'tab'			=> true,
				'priority'		=> 'default',
				'priority'		=> 'high',
				'fields'		=> array(
					array(
						'name'  			=> esc_html__( 'Portfolio Layout', 'pressmart' ),
						'label_description' => esc_html__( 'Select portfolio layout', 'pressmart' ),
						'id'    			=> $prefix."portfolio_style",
						'type'  			=> 'image_set',
						'allowClear' 		=> false,
						'options' 			=> array(
							'default'	=> PRESSMART_ADMIN_IMAGES . 'layout/default.png',
							'4'	  		=> PRESSMART_ADMIN_IMAGES . 'layout/portfolio/4_8-layout.png',
							'6'	  		=> PRESSMART_ADMIN_IMAGES . 'layout/portfolio/6_6-layout.png',
							'8'	  		=> PRESSMART_ADMIN_IMAGES . 'layout/portfolio/8_4-layout.png',
							'12'		=> PRESSMART_ADMIN_IMAGES . 'layout/portfolio/12_12-layout.png',
						),
						'std'				=> 'default',
						'multiple' 			=> false,							
					),
					array(
						'name'  			=> esc_html__( 'Client Name', 'pressmart' ),
						'label_description' => esc_html__( 'Enter client name.', 'pressmart' ),
						'id'    			=> $prefix.'client_name',
						'type'  			=> 'text',
					),
					array(
						'name'  			=> esc_html__( 'Website', 'pressmart' ),
						'label_description' => esc_html__( 'Website link.', 'pressmart' ),
						'id'    			=> $prefix.'website_link',
						'type'  			=> 'text',
					),
					array(
						'id'               	=> $prefix.'gallery_images',
						'name'             	=> esc_html__( 'Portfolio Images Upload', 'pressmart' ),
						'label_description'	=> esc_html__( 'Upload portfolio images.', 'pressmart' ),
						'type'             	=> 'image_advanced',
						'force_delete'     	=> false,
					),
					array(
						'name'  			=> esc_html__( 'Thumbnail/Gallery', 'pressmart' ),
						'label_description' => esc_html__( 'Show gallery Or thumbnail.', 'pressmart' ),
						'id'    			=> $prefix.'show_portfolio_gallery',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'gallery'	=> esc_html__( 'Gallery', 'pressmart' ),
							'thumbnail'	=> esc_html__( 'Thumbnail', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',							
					),
					array(
						'name'  			=> esc_html__( 'Gallery Style', 'pressmart' ),
						'label_description' => esc_html__( 'Select portfolio gallery style.', 'pressmart' ),
						'id'    			=> $prefix.'portfolio_gallery_style',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'		=> esc_html__( 'Default', 'pressmart' ),
							'slider'     	=> esc_html__( 'Slider', 'pressmart' ),
							'grid'     		=> esc_html__( 'Grid', 'pressmart' ),
							'one-column'    => esc_html__( 'One Column', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',							
					),
				),
			);
			
			/* Product meta */
			$size_guide = pressmart_get_posts_by_post_type('pls_size_chart',esc_html__('Select Size Chart','pressmart'));
			
			$meta_boxes[] = array(
				'id' 			=> $prefix . 'product_setting_meta_box',
				'title' 		=> esc_html__('Product Setting', 'pressmart'),
				'post_types' 	=> array('product'),
				'tab' 			=> true,
				'fields' 		=> array(
					array(
						'name'  			=> esc_html__( 'Product Page Layout', 'pressmart' ),
						'label_description'	=> esc_html__( 'Select product page  layout.', 'pressmart' ),
						'id'    			=> $prefix.'single_product_layout',
						'type'  			=> 'image_set',
						'allowClear' 		=> true,
						'options' 			=> array(
							'product-gallery-left'	  		=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-left.png',
							'product-gallery-bottom'		=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-bottom.png',
							'product-gallery-horizontal'	=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-horizontal.png',
							'product-gallery-center'		=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-center.png',
							'product-gallery-grid'			=> PRESSMART_ADMIN_IMAGES . 'product-page/product-gallery-grid.png',
							'product-sticky-info'			=> PRESSMART_ADMIN_IMAGES . 'product-page/product-sticky-info.png',
						),
						'std'				=> '',
						'multiple' 			=> false,
						'required' 			=> true,
					),
					array(
						'name' 				=> esc_html__( 'Product Video url', 'pressmart' ),
						'id'   				=> $prefix . 'product_video',
						'label_description'	=> esc_html__( 'Youtube, Vimeo embaded link', 'pressmart' ),
						'type' 				=> 'text',
					),
					array(
						'name' 				=> esc_html__( 'Product Size Guide', 'pressmart' ),
						'label_description'	=> esc_html__( 'Select product size guide.', 'pressmart' ),
						'id'   				=> $prefix . 'size_guide',
						'type' 				=> 'select',
						'options'			=> $size_guide,
						'max_file_uploads' 	=> 1,
					),
					array(
						'name'             	=> esc_html__( 'Product 360 Degree Images', 'pressmart' ),
						'label_description'	=> esc_html__( 'Upload 360 degree images.', 'pressmart' ),
						'id'               	=> $prefix . 'product_360_degree_images',
						'type'             	=> 'image_advanced',
						'force_delete'     	=> false,
					),
					array(
						'name'  			=> esc_html__( 'Bought Together Location', 'pressmart' ),
						'label_description'	=> esc_html__( 'Select Bought Together Location.', 'pressmart' ),
						'id'    			=> $prefix . 'product_bought_together_location',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'			=> esc_html__('Default','pressmart'),
							'summary-bottom' 	=> esc_html__('Summary Bottom','pressmart'),
							'after-summary'  	=> esc_html__('After Summary','pressmart'),
							'in-tab'  			=> esc_html__('In Tab','pressmart'),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),						
					array(
						'name'  			=> esc_html__( 'Product Tabs Style', 'pressmart' ),
						'label_description' => esc_html__( 'Select Product Tabs Style.', 'pressmart' ),
						'id'    			=> $prefix . 'single_product_tabs_style',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'		=> esc_html__('Default','pressmart'),
							'tabs' 			=> esc_html__('Tabs','pressmart'),
							'accordion'  	=> esc_html__('Accordion','pressmart'),
							'toggle'  		=> esc_html__('Toggle','pressmart'),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Product Tabs Location', 'pressmart' ),
						'label_description' => esc_html__( 'Select Product Tabs Location.', 'pressmart' ),
						'id'    			=> $prefix . 'single_product_tabs_location',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'			=> esc_html__('Default','pressmart'),
							'after-summary' 	=> esc_html__('After Summary','pressmart'),
							'summary-bottom'  	=> esc_html__( 'Summary Bottom', 'pressmart' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
				)
			);
			
			$meta_boxes[] = array(
				'id' 			=> $prefix . 'product_custom_tab_meta',
				'title' 		=> esc_html__('Product Custom Tab', 'pressmart'),
				'post_types' 	=> array('product'),
				'fields' 		=> array(
					array(
						'name'  			=> esc_html__( 'Enable Custom Tab.', 'pressmart' ),
						'label_description'	=> esc_html__( 'Check this for enable custom tab.', 'pressmart' ),
						'id'    			=> $prefix . 'enable_custom_tab',
						'type'  			=> 'checkbox',
						'std'				=> 0,
					),
					array (
						'name' 				=> esc_html__('Custom Tab Title', 'pressmart'),
						'label_description' => esc_html__( 'Enter tab title.', 'pressmart' ),
						'id' 				=> $prefix . 'product_custom_tab_heading',
						'type' 				=> 'text',
						'std' 				=> '',
						'required-field' 	=> array( $prefix . 'enable_custom_tab', '=', array( '1' ) ),
					),
					array(
						'name'  			=> esc_html__( 'Custom Tab Content.', 'pressmart' ),
						'label_description' => esc_html__( 'Enter tab content.', 'pressmart' ),
						'id'    			=> $prefix . 'product_custom_tab_content',
						'type'  			=> 'wysiwyg',
						'raw'     			=> false,
						'options' 			=> array(
							'textarea_rows' 	=> 4,
							'teeny'         	=> true,
						),
						'required-field' 	=> array( $prefix . 'enable_custom_tab', '=', array( '1' ) ),
					), 
				)
			);

			/* Page  Options */
			$meta_boxes[] = array(
				'title' 		=> 	esc_html__('Page Layout', 'pressmart'),
				'id' 			=> $prefix.'layout_options',
				'post_types' 	=> $this->post_types,
				'tab' 			=> 	true,
				'fields' 		=> 	array(
					array(
						'name'  		=> esc_html__( 'Page Sidebar', 'pressmart' ),
						'id'    		=> $prefix.'page_layout',
						'type'  		=> 'image_set',
						'allowClear' 	=> true,
						'options' 		=> array(
							'full-width'	  => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-none.png',
							'left-sidebar'	  => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-left.png',
							'right-sidebar'	  => PRESSMART_ADMIN_IMAGES . 'layout/sidebar-right.png',
						),
						'std'			=> '',
						'multiple' 		=> false,
						'required' 		=> true,
					),
					array (
						'name' 				=> esc_html__('Sidebar Widget', 'pressmart'),
						'id' 				=> $prefix.'sidebar_widget',
						'type' 				=> 'sidebar',
						'field_type'  		=> 'select_advanced',
						'placeholder' 		=> esc_attr__('Select Sidebar','pressmart'),
						'std' 				=> '',	
						'required-field' 	=> array($prefix . 'page_layout', '=', array( 'left-sidebar', 'right-sidebar' ) ),
						'label_description'	=> esc_html__('Select sidebar. If empty then it take value from theme options.','pressmart'),																
					),										
				),
			);
			/* End Page Options */

			/* Header Options */
			$meta_boxes[] = array(
				'title' 		=> esc_html__('Header', 'pressmart'),
				'id' 			=> $prefix .'header_options',
				'post_types' 	=> array('post','page','portfolio','product'),
				'tab' 			=> true,
				'fields' 		=> 	array(
					array(
						'name'  			=> esc_html__( 'Header Top', 'pressmart' ),
						'label_description'	=> esc_html__( 'Enable or disable the top bar.', 'pressmart' ),
						'id'    			=> $prefix . 'header_top',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Header', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable the header.', 'pressmart' ),
						'id'    			=> $prefix . 'header',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Select Header Style', 'pressmart' ),
						'label_description' => esc_html__( 'Select header style.', 'pressmart' ),
						'id'    			=> $prefix.'header_style',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'		=> esc_html__( 'Default', 'pressmart' ),
							'1'      		=> esc_html__( 'Header 1', 'pressmart' ),
							'2'   			=> esc_html__( 'Header 2', 'pressmart' ),
							'3' 			=> esc_html__( 'Header 3', 'pressmart' ),
							'4'				=> esc_html__( 'Header 4', 'pressmart' ),
							'5'				=> esc_html__( 'Header 5', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Header Transparent', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable the header transparent/overlay.', 'pressmart' ),
						'id'    			=> $prefix . 'header_transparent',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
					array(
						'name'  			=> esc_html__( 'Header Transparent Color', 'pressmart' ),
						'label_description' => esc_html__( 'Select header color schema.', 'pressmart' ),
						'id'    			=> $prefix . 'header_transparent_color',
						'type'  			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'light'    	=> esc_html__( 'Light', 'pressmart' ),
							'dark' 		=> esc_html__( 'Dark', 'pressmart' ),
						),
						'std'			=> 'default',
						'multiple' 		=> false,
					),
				),
			);
			/* End Header Options */

			/* Title Options */
			$meta_boxes[] = array(
				'title' 		=> esc_html__('Page Title', 'pressmart'),
				'id' 			=> $prefix.'page_title_options',
				'post_types' 	=> array('post','page','portfolio'),
				'tab' 			=> true,
				'fields' 		=> 	array(
					array(
						'name'  			=> esc_html__( 'Page Title', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable the page title.', 'pressmart' ),
						'id'    			=> $prefix.'page_title_section',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable'	=> esc_html__('Enable','pressmart'),
							'disable'	=> esc_html__('Disable','pressmart'),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Heading', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable the heading.', 'pressmart' ),
						'id'    			=> $prefix.'page_heading',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name' 				=> esc_html__( 'Custom Header Title', 'pressmart' ),
						'label_description'	=> esc_html__( 'Alter the main title display.', 'pressmart' ),
						'desc' 				=> '',
						'id' 				=> $prefix . 'custom_page_title',
						'type' 				=> 'text',
					),
					array(
						'name'  			=> esc_html__( 'Title Style', 'pressmart' ),
						'label_description' => esc_html__( 'Select a page title style.', 'pressmart' ),
						'id'    			=> $prefix.'page_title_style',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'left' 		=> esc_html__('Left','pressmart'),
							'center'	=> esc_html__('Centered','pressmart'),							
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Header Font Size', 'pressmart' ),
						'label_description' => esc_html__( 'Select page title font size.', 'pressmart' ),
						'id'    			=> $prefix.'title_font_size',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'small'    	=> esc_html__( 'Small', 'pressmart' ),
							'large'		=> esc_html__( 'Large', 'pressmart' ),						
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std'			=> 'default',
					),
					array(
						'name' 				=> esc_html__( 'Padding Top', 'pressmart' ),
						'desc' 				=> '',
						'id' 				=> $prefix.'title_padding_top',
						'type' 				=> 'number',
					),
					array(
						'name' 				=> esc_html__( 'Padding Bottom', 'pressmart' ),
						'desc' 				=> '',
						'id' 				=> $prefix.'title_padding_bottom',
						'type' 				=> 'number',
					),
					array(
						'name'  			=> esc_html__( 'Background Color', 'pressmart' ),
						'label_description' => esc_html__( 'Select a background color for title.', 'pressmart' ),
						'id'    			=> $prefix.'title_bg_color',
						'type'  			=> 'color',
					),
					array(
						'name' 				=> esc_html__( 'Color', 'pressmart' ),
						'label_description'	=> esc_html__( 'Select a title color.', 'pressmart' ),
						'desc' 				=> '',
						'id' 				=> $prefix.'title_color',
						'type'     			=> 'button_group',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'light'    	=> esc_html__( 'Light', 'pressmart' ),
							'dark' 		=> esc_html__( 'Dark', 'pressmart' ),
						),
						'inline'   		=> 	true,
						'multiple' 		=> 	false,
						'std' 			=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Background Image', 'pressmart' ),
						'label_description' => esc_html__( 'Select a custom image for your main title.', 'pressmart' ),
						'id'    			=> $prefix.'title_bg_img',
						'type'  			=> 'single_image',
					),
					array(
						'name'  			=> esc_html__( 'Position', 'pressmart' ),
						'label_description' => esc_html__( 'Select your background image position.', 'pressmart' ),
						'id'    			=> $prefix.'title_bg_position',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'		=> esc_html__( 'Default', 'pressmart' ),
							'left-top'      => esc_html__( 'Left Top', 'pressmart' ),
							'left-center'   => esc_html__( 'Left Center', 'pressmart' ),
							'left-bottom' 	=> esc_html__( 'Left Bottom', 'pressmart' ),
							'right-top'		=> esc_html__( 'Right Top', 'pressmart' ),
							'right-center'	=> esc_html__( 'Right Center', 'pressmart' ),
							'right-bottom'	=> esc_html__( 'Right Bottom', 'pressmart' ),
							'center-top'	=> esc_html__( 'Center Top', 'pressmart' ),
							'center-center'	=> esc_html__( 'Center Center', 'pressmart' ),
							'center-bottom'	=> esc_html__( 'Center Bottom', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Attachment', 'pressmart' ),
						'label_description' => esc_html__( 'Select your background image attachment.', 'pressmart' ),
						'id'    			=> $prefix.'title_bg_attachment',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'scroll'    => esc_html__( 'Scroll', 'pressmart' ),
							'fixed' 	=> esc_html__( 'Fixed', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Repeat', 'pressmart' ),
						'label_description' => esc_html__( 'Select your background image repeat.', 'pressmart' ),
						'id'    			=> $prefix.'title_bg_repeat',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'no-repeat'	=> esc_html__( 'No-Repeat', 'pressmart' ),
							'repeat'    => esc_html__( 'Repeat', 'pressmart' ),
							'repeat-x'  => esc_html__( 'Repeat-X', 'pressmart' ),
							'repeat-y' 	=> esc_html__( 'Repeat-Y', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name'  			=> esc_html__( 'Size', 'pressmart' ),
						'label_description' => esc_html__( 'Select your background image size.', 'pressmart' ),
						'id'    			=> $prefix.'title_bg_size',
						'type'     			=> 'select',
						'options'  			=> array(
							'default'	=> esc_html__( 'Default', 'pressmart' ),
							'auto'		=> esc_html__( 'Auto', 'pressmart' ),
							'cover'     => esc_html__( 'Cover', 'pressmart' ),
							'contain'   => esc_html__( 'contain', 'pressmart' ),
						),
						'inline'   			=> 	true,
						'multiple' 			=> 	false,
						'std'				=>	'default',
					),
					array(
						'name' 				=> esc_html__( 'Background Opacity', 'pressmart' ),
						'label_description' => esc_html__( 'Enter a number between 0.1 to 1. Default is 0.5.', 'pressmart' ),
						'desc' 				=> '',
						'id' 				=> $prefix . 'title_bg_opacity',
						'type' 				=> 'number',
						'min'  				=> 0,
						'max'  				=> 1,
						'step' 				=> 0.1,
					),
					array(
						'type'     			=> 'button_group',
						'id'    			=> $prefix.'breadcrumb',
						'name'  			=> esc_html__( 'Show Breadcrubm', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable the page title breadcrumbs.', 'pressmart' ),
						'options'  			=> array(
							'default'   => esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std' 				=> 'default',
					),	
				),
			);
			/* End Title Options */

			/* Footer Options */
			$meta_boxes[] = array(
				'title' 		=> esc_html__('Footer', 'pressmart'),
				'id' 			=> $prefix .'footer_options',
				'post_types' 	=> array('post','page','portfolio','product'),
				'tab' 			=> true,
				'fields' 		=> 	array(
					array(
						'name'  			=> esc_html__( 'Footer', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable footer.', 'pressmart' ),
						'id'    			=> $prefix . 'site_footer',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'				=> 'default',
						'multiple' 			=> false,
					),
					array(
						'name'  			=> esc_html__( 'Subscribe', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable subscribe.', 'pressmart' ),
						'id'    			=> $prefix.'footer_subscribe',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'				=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Popular Categories', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable categories.', 'pressmart' ),
						'id'    			=> $prefix.'footer_categories',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'				=> 'default',
					),
					array(
						'name'  			=> esc_html__( 'Copyright', 'pressmart' ),
						'label_description' => esc_html__( 'Enable or disable copyright.', 'pressmart' ),
						'id'    			=> $prefix.'footer_copyright',
						'type'  			=> 'button_group',
						'options' 			=> array(
							'default'	=> esc_html__('Default','pressmart'),
							'enable' 	=> esc_html__('Enable','pressmart'),
							'disable'  	=> esc_html__('Disable','pressmart'),
						),
						'std'				=> 'default',
					),
				),
			);
			/* End Footer Options */

			return $meta_boxes;
			
		}
		public function register_metaboxes(){
			$meta_boxes = $this->meta_boxes();
			// Make sure there's no errors when the plugin is deactivated or during upgrade
			if (class_exists('RW_Meta_Box')) {
					foreach ($meta_boxes as $meta_box) {
							new RW_Meta_Box($meta_box);
					}
			}
		}
		public function admin_js_var(){
			$meta_boxes = $this->meta_boxes();
			$meta_box_id = '';
			foreach ($meta_boxes as $box) {
				if (!isset($box['tab'])) {
					continue;
				}
				if ( !empty( $meta_box_id ) ) {
					$meta_box_id .= ',';
				}
				$meta_box_id .= '#' . $box['id'];
			}
			$pressmart_option_string = apply_filters( 'pressmart_theme_name','PressMart' ).' '.esc_html__('Options','pressmart');
			wp_enqueue_script( 'pressmart-meta-box', PRESSMART_FRAMEWORK_URI . '/admin/assets/js/meta-box.js');
			$pls_meta_data	= apply_filters( 'pressmart_meta_data_arg', array( 
								'meta_box_ids'	=> $meta_box_id,
								'meta_box_title'	=> $pressmart_option_string,
							) );
			
			wp_localize_script( 'pressmart-meta-box' , 'pressmart_meta_data' ,$pls_meta_data );
		}		
	}

	/**
	 * Initialize class object with 'get_instance()' method
	 */
	PressMart_Metabox::get_instance();

endif;