<?php
/**
 * PressMart Dashboard
 *
 * Handles the about us page HTML
 *
 * @package PressMart
 * @since 1.0
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

$pressmart_tabs = apply_filters('pressmart_dashboard_tabs', array(
					'pressmart-theme' 			=> esc_html__("Dashboard", 'pressmart'),
					'pressmart-system-status' 	=> esc_html__("System Status", 'pressmart'),
					'pressmart-theme-option' 	=> esc_html__("Theme Options", 'pressmart'),
				));
$active_tab 	= isset($_GET['page']) ? $_GET['page'] : 'pressmart-theme'; 
?>
<div class="wrap about-wrap pressmart-admin-wrap pressmart-dashboard-wrap">
	
	<h1>
		<?php
		echo apply_filters( 'pressmart_dashboard_title', esc_html__('Welcome to', 'pressmart').' PressMart' );
		?>
	</h1>
	<div class="about-text">
		<?php 
		echo apply_filters( 'pressmart_dashboard_description', esc_html__('Thank you for purchasing our premium pressmart theme. Here you are able to start creating your awesome web store by importing our dummy content and theme options.', 'pressmart'));
		?>
	</div>
	<div class="pressmart-theme-badge">
		<?php $dashlogo_url = apply_filters( 'pressmart_dashboard_logo', PRESSMART_URI.'/inc/admin/assets/images/dashboard-logo.png' ) ?>
		<img src="<?php echo esc_url( $dashlogo_url ); ?>">
		<span><?php echo esc_html__('Version', 'pressmart') .' '.PRESSMART_VERSION; ?></span>
	</div>
	
	<?php 
	$action_button = apply_filters( 'pressmart_dashboard_docs_rating_button', true);
	if( $action_button ){ ?>
	<p class="pressmart-actions">
		<a class="btn-docs button" href="https://docs.presslayouts.com/pressmart/" target="_blank"><?php esc_html_e('Documentation','pressmart');?></a>
		<a class="btn-docs button" href="https://1.envato.market/PMsupport" target="_blank"><?php esc_html_e('Support','pressmart');?></a>
		<a class="btn-rate button" href="https://themeforest.net/downloads" target="_blank"><?php esc_html_e('Rate our theme','pressmart');?></a>
    </p>
	<?php }
	if( !empty( $pressmart_tabs ) ) { ?>
		<h2 class="nav-tab-wrapper">
			<?php foreach ($pressmart_tabs as $tab_key => $tab_val) { 

				if( empty($tab_key) ) {
					continue;
				}
				if( !defined( 'PRESSMART_CORE_DIR' ) && $tab_key == 'pressmart-theme-option') {
					continue;
				}
				$active_tab_cls	= ( $active_tab == $tab_key ) ? ' nav-tab-active' : '';
				$tab_link 		= add_query_arg( array( 'page' => $tab_key ), admin_url('admin.php') );
				?>
				<a class="nav-tab<?php echo esc_attr( $active_tab_cls ); ?>" href="<?php echo esc_url( $tab_link ); ?>"><?php echo esc_html( $tab_val ); ?></a>
			<?php } ?>
		</h2>
	<?php } ?>
	<div id="pressmart-dashboard" class="pressmart-dashboard wp-clearfix">
	