<?php
/**
 * The Header of theme
 *
 * @author 	PressLayouts
 * @package pressmart
 * @since 1.0
 */ 
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
	<link rel="profile" href="//gmpg.org/xfn/11">
	<?php do_action( 'pressmart_head_bottom' ); ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<?php do_action( 'pressmart_body_top' ); ?>
	
	<div id="page" class="site-wrapper">
		
		<?php if( ! pressmart_has_elementor_template( 'header' ) ) :
			/**
			 * Hook: pressmart_header.
			 *
			 * @hooked pressmart_template_header- 10
			 */
			do_action( 'pressmart_header' );
		endif; ?>
		
		<?php if( ! pressmart_has_elementor_template( 'archive' ) ) : ?>
		
		<?php
		/**
		 * Hook: pressmart_page_title.
		 *
		 * @hooked pressmart_template_page_title - 10
		 */
		do_action( 'pressmart_page_title' );
		
		endif; ?>			
		
		<div id="main-content" class="site-content">
		
			<?php do_action( 'pressmart_site_content_top' ); ?>
			
			<div class="container">
				<?php do_action( 'pressmart_after_container' ); ?>
				<div class="<?php pressmart_row_classes(); ?>">