<?php
/**
 * Template part for displaying archive portfolio
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @author 	PressLayouts
 * @package pressmart
 * @since 1.0
 */

get_header(); ?>

<?php if( ! pressmart_has_elementor_template( 'archive' ) ) :
	/**
	 * Hook: pressmart_before_main_content.
	 *
	 * @hooked pressmart_output_content_wrapper - 10 (outputs opening divs for the content area)
	 */
	do_action( 'pressmart_before_main_content' );

	if ( have_posts() ) :

		/**
		 * Hook: pressmart_before_portfolio_loop.
		 *
		 * @hooked pressmart_portfolio_filter - 10
		 */
		do_action( 'pressmart_before_portfolio_loop' );
		
		pressmart_portfolio_loop_start();
		
		while ( have_posts() ) :
			the_post();	
			
			// Include the portfolio loop content template.
			get_template_part( 'template-parts/portfolio-loop/layout', get_post_format() );

		endwhile;
		
		pressmart_portfolio_loop_end();
		
		/**
		 * Hook: pressmart_after_portfolio_loop.
		 *
		 * @hooked pressmart_portfolio_pagination - 10
		 */
		do_action( 'pressmart_after_portfolio_loop' );

	else :

		get_template_part( 'template-parts/content', 'none' );

	endif;

	/**
	 * Hook: pressmart_after_main_content.
	 *
	 * @hooked pressmart_output_content_wrapper_end - 10 (outputs closing divs for the content)
	 */
	do_action( 'pressmart_after_main_content' );

	/**
	 * Hook: pressmart_sidebar.
	 *
	 * @hooked pressmart_get_sidebar - 10
	 */
	do_action( 'pressmart_sidebar' );
endif; ?>

<?php get_footer();